/* 
 * primes_detached.c 
 *
 * Обчислює просте число з заданим номером (WHICH_PRIME).
 * Просте число обчислюється за допомогою від'єднаного потоку.
 * Результат виводить дочірній потік.
 * Ілюструє порядок управління придатністю потоків до приєднання
 * (функція pthread_detach()).
 *
 */

#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

/* Номер простого числа, яке треба знайти. */
enum { WHICH_PRIME = 100 };

void *compute_prime(void *arg);


/* Знаходить просте число з номером, переданим через аргумент,
   і виводить результат. */
void *compute_prime(void *arg)
{
        unsigned long long cand = 2;
        unsigned int which_prime = *((unsigned int *) arg);
        unsigned int n = which_prime;
        int terrno;

        /* Від'єднується. */
        terrno = pthread_detach(pthread_self());
        if (terrno != 0)
                fprintf(stderr, "Error detaching thread: %s\n",
                                                        strerror(terrno));

        while (1) {
                int factor;
                int is_prime = 1;

                for (factor = 2; factor < cand; factor++) {
                        if (cand % factor == 0) {
                                is_prime = 0;
                                break;
                        }
                }
                if (is_prime && --n == 0) {
                        /* Виводить результат. */
                        printf("The %uth prime number is %llu.\n",
                                                        which_prime, cand);
                        return NULL;
                }
                cand++;
        }
        return NULL;
}

int main()
{
        pthread_t thread;
        unsigned int which_prime = WHICH_PRIME;
        int terrno;

        /* Створює потік, який обчислює просте число з номером which_prime
           і виводить результат. */
        terrno = pthread_create(&thread, NULL, &compute_prime,
                                                        &which_prime);
        if (terrno != 0) {
                fprintf(stderr, "Error creating thread: %s\n",
                                                        strerror(terrno));
                exit(EXIT_FAILURE);
        }

        /* Призупиняється, оскільки передчасне завершення даного потоку
           завадить виконати свою роботу дочірньому потоку. */
        pause();

        return EXIT_SUCCESS;
}
